<?php

namespace App\Http;

use App\Http\Middleware\LogsApiMiddleware;
use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array
     */
    protected $middleware = [
	    \Illuminate\Foundation\Http\Middleware\CheckForMaintenanceMode::class,
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            
        ],

        'api' => [
            'throttle:60,1',
            'bindings',
        ],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array
     */
    protected $routeMiddleware = [
        'corporate' => \App\Http\Middleware\RedirectIfNotCorporate::class,
        'corporate.guest' => \App\Http\Middleware\RedirectIfCorporate::class,
        'account' => \App\Http\Middleware\RedirectIfNotAccount::class,
        'account.guest' => \App\Http\Middleware\RedirectIfAccount::class,
        'fleet' => \App\Http\Middleware\RedirectIfNotFleet::class,
        'fleet.guest' => \App\Http\Middleware\RedirectIfFleet::class,
        'dispatcher' => \App\Http\Middleware\RedirectIfNotDispatcher::class,
        'dispatcher.guest' => \App\Http\Middleware\RedirectIfDispatcher::class,
        'provider' => \App\Http\Middleware\RedirectIfNotProvider::class,
        'provider.guest' => \App\Http\Middleware\RedirectIfProvider::class,
        'provider.api' => \App\Http\Middleware\ProviderApiMiddleware::class,
        'passport.provider' => \App\Http\Middleware\PassportProviderMiddleware::class,
        'combo' => \App\Http\Middleware\RedirectIfNotCombo::class,
        'admin' => \App\Http\Middleware\RedirectIfNotAdmin::class,
        'admin.guest' => \App\Http\Middleware\RedirectIfAdmin::class,
        'auth' => \Illuminate\Auth\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'bindings' => \Illuminate\Routing\Middleware\SubstituteBindings::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'language' => \App\Http\Middleware\LanguageMiddleware::class,
        'provider.language' => \App\Http\Middleware\ProviderLanguageMiddleware::class,        
        'admin.language' => \App\Http\Middleware\AdminLanguageMiddleware::class,        
        'fleet.language' => \App\Http\Middleware\FleetLanguageMiddleware::class,        
        'account.language' => \App\Http\Middleware\AccountLanguageMiddleware::class,        
        'dispatcher.language' => \App\Http\Middleware\DispatcherLanguageMiddleware::class,        
        'jwt.auth' => 'Tymon\JWTAuth\Middleware\GetUserFromToken',
        'jwt.refresh' => 'Tymon\JWTAuth\Middleware\RefreshToken',
        'demo' => \App\Http\Middleware\DemoModeMiddleware::class,
        'logs' => LogsApiMiddleware::class,
    ];
}
